﻿using System;
using System.Configuration;
using System.Collections.Generic;
using System.Web;
using System.Web.Configuration;
using System.Linq;
using System.Web.Services;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.ServiceModel.Activation;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP_SERVICE
{
    [WebService(Namespace = "http://URL         .DNS   ")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [WebServiceBindingAttribute(Name = "MviServices", Namespace = "http://URL         .DNS   ")]
    [ServiceContract(Name = "MviServices", Namespace = "http://URL         .DNS   ")]
    [System.ComponentModel.ToolboxItem(false)]
    [AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
    [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single)]
    public partial class MviServices : System.Web.Services.WebService
    {
        #region MVI

        [WebMethod]
        public bool PRPA_IN201305UV02(string identity, int registryId, int patientId, int mviTypeId)
        {
            return VIRPManager.PRPA_IN201305UV02(identity, registryId, patientId, mviTypeId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/PRPA_IN201305UV02?identity={identity}&registryId={registryId}&patientId={patientId}&mviTypeId={mviTypeId}")]
        public bool PRPA_IN201305UV02_XML(string identity, int registryId, int patientId, int mviTypeId)
        {
            return this.PRPA_IN201305UV02(identity, registryId, patientId, mviTypeId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/PRPA_IN201305UV02?identity={identity}&registryId={registryId}&patientId={patientId}&mviTypeId={mviTypeId}")]
        public bool PRPA_IN201305UV02_JSON(string identity, int registryId, int patientId, int mviTypeId)
        {
            return this.PRPA_IN201305UV02(identity, registryId, patientId, mviTypeId);
        }

        [WebMethod]
        public bool PRPA_IN201309UV02(string identity, int registryId, int patientId)
        {
            return VIRPManager.PRPA_IN201309UV02(identity, registryId, patientId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/PRPA_IN201309UV02?identity={identity}&registryId={registryId}&patientId={patientId}")]
        public bool PRPA_IN201309UV02_XML(string identity, int registryId, int patientId)
        {
            return this.PRPA_IN201309UV02(identity, registryId, patientId);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/PRPA_IN201309UV02?identity={identity}&registryId={registryId}&patientId={patientId}")]
        public bool PRPA_IN201309UV02_JSON(string identity, int registryId, int patientId)
        {
            return this.PRPA_IN201309UV02(identity, registryId, patientId);
        }

        [WebMethod]
        public string GET_PATIENT_ICN(string identity, string lastName, string firstName, string dateOfBirth, string gender, string snum)
        {
            return VIRPManager.GET_PATIENT_ICN(identity, lastName, firstName, dateOfBirth, gender, snum);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "/Xml/GET_PATIENT_ICN?identity={identity}&lastName={lastName}&firstName={firstName}&dateOfBirth={dateOfBirth}&gender={gender}&snum={snum}")]
        public string GET_PATIENT_ICN_XML(string identity, string lastName, string firstName, string dateOfBirth, string gender, string snum)
        {
            return this.GET_PATIENT_ICN(identity, lastName, firstName, dateOfBirth, gender, snum);
        }

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/Json/GET_PATIENT_ICN?identity={identity}&lastName={lastName}&firstName={firstName}&dateOfBirth={dateOfBirth}&gender={gender}&snum={snum}")]
        public string GET_PATIENT_ICN_JSON(string identity, string lastName, string firstName, string dateOfBirth, string gender, string snum)
        {
            return this.GET_PATIENT_ICN(identity, lastName, firstName, dateOfBirth, gender, snum);
        }

        #endregion
    }
}